import { useForwardExpose } from "../shared/useForwardExpose.js";
import { DialogClose_default } from "../Dialog/DialogClose.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, unref, withCtx } from "vue";

//#region src/AlertDialog/AlertDialogAction.vue?vue&type=script&setup=true&lang.ts
var AlertDialogAction_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "AlertDialogAction",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false,
			default: "button"
		}
	},
	setup(__props) {
		const props = __props;
		useForwardExpose();
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(DialogClose_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/AlertDialog/AlertDialogAction.vue
var AlertDialogAction_default = AlertDialogAction_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { AlertDialogAction_default };
//# sourceMappingURL=AlertDialogAction.js.map