import { defineComponent, computed, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "hero-section",
  __ssrInlineRender: true,
  props: {
    title: {},
    description: {},
    bg: {}
  },
  setup(__props) {
    const backgroundStyle = computed(() => ({
      backgroundImage: `linear-gradient(to top, rgba(0,0,0,0.6), rgba(0,0,0,0.1)), url('${__props.bg}')`
    }));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: "w-full bg-primary bg-no-repeat bg-cover bg-opacity-10 bg-center min-h-[70svh] flex flex-col justify-center items-center text-white",
        style: backgroundStyle.value
      }, _attrs))}><div class="container mx-auto px-6"><div class="text-center mb-8 max-w-4xl mx-auto"><h1 class="font-playfair text-4xl md:text-5xl font-semibold mb-4">${ssrInterpolate(__props.title)}</h1><p class="font-inter text-lg max-w-2xl mx-auto">${ssrInterpolate(__props.description)}</p></div></div></section>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/hero-section.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = Object.assign(_sfc_main, { __name: "HeroSection" });

export { __nuxt_component_0 as _ };
//# sourceMappingURL=hero-section-BfzZdP6x.mjs.map
